<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Mas extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('mas_model');
    }

    // Función para agregar
    public function index_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->mas_model->agregarMas($post);

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function maspag_post()
    {
        $this->load->model('mas_model');
        $respuesta = $this->mas_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar
     public function index_put()
     {
 
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->mas_model->actualizarMas($this->put());
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

      // Función para obtener la lista de los tipos de mass
    public function mas_get($idmas = 0)
    {

        if ($idmas != 0)
        {
             // Devolviendo los mass con un codigo 200 HTTP_OK
            $respuesta = $this->mas_model->obtenermas($idmas);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo el mas con un codigo 200 HTTP_OK
            $respuesta = $this->mas_model->obtenermas();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

    // Función para actualizar
    public function actualizar_mas_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->mas_model->actualizarMas($post);

       $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para eliminar
    public function eliminar_mas_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->mas_model->eliminarMas($post);

       $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Función para actualizar
    public function cambiar_orden_post()
    {
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->mas_model->cambiar_orden($this->post());

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

}