<?php
class Infopagina_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('infopagina_model');
    }

    // Función para obtener la infopagina basada en el ID
    public function obtenerInfopagina($idinfopagina)
    {
        $this->db->select('*')->from('infopagina')->where('id =', $idinfopagina);

        $infopagina = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $infopagina,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    // Función para guardar la infopagina
    public function guardarInfopagina($infopagina)
    {
        $id             = $infopagina["id"];
        $titulo         = $infopagina["titulo"];
        $descripcion    = $infopagina["descripcion"];
        $categoria      = $infopagina["idcategoria"];
        $imagen        = $infopagina["imagen"];

        // Creando el array con los datos básicos del usuario
        $infopagina = array(
            'id'            => $id,
            'titulo'        => $titulo,
            'descripcion'   => $descripcion,
            'categoria'     => $categoria,
            'imagen'       => $imagen,
        );

        //Iniciando la transacción
        $this->db->trans_begin();

        // Actualizando la tabla de usuarios
        // $this->db->set($infopagina);
        // $this->db->where('id', $id);
        $this->db->insert('infopagina', $infopagina);
        $id = $this->db->insert_id();

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al agregar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'id' => $id,
                'respuesta' => 'Infopagina agregada correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    // Función para actualizar la infopagina
    public function actualizarInfopagina($infopagina)
    {
        $id             = $infopagina["id"];
        $titulo         = $infopagina["titulo"];
        $descripcion    = $infopagina["descripcion"];
        $categoria      = $infopagina["idcategoria"];
        $imagen        = $infopagina["imagen"];

        // Creando el array con los datos básicos del usuario
        $infopagina = array(
            'id'            => $id,
            'titulo'        => $titulo,
            'descripcion'   => $descripcion,
            'idcategoria'     => $categoria,
            'imagen'       => $imagen,
        );

        //Iniciando la transacción
        $this->db->trans_begin();

        // Actualizando la tabla de usuarios
        $this->db->set($infopagina);
        $this->db->where('id', $id);
        $this->db->update('infopagina');

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al actualizar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'respuesta' => 'Infopagina actualizado correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'infopagina');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function cambiar_estado($datos)
    {
        $idinfopagina = $datos['idinfopagina'];
        $value = $datos['value'];

        if(isset($idinfopagina))
        {
            $update = $this->db->where('id', $idinfopagina)->update('infopagina', array('visible' => $value));
            if ($update) {
                $respuesta = array(
                    'mensaje' => 'Actualizacion de estado correcta',
                    'status' => 200,
                );
            } else {
                $respuesta = array(
                    'mensaje' => 'Error en actualizacion de estado',
                    'error' => $this->db->error(),
                    'status' => 409,
                );
            }
        }
        else 
        {
            $respuesta = array(
                'mensaje' => 'Error interno',
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function actualizarImagen($post)
    {   
         //Iniciando la transacción
         $this->db->trans_begin();
         $this->load->library('upload');
         // print_r($_SERVER['DOCUMENT_ROOT'].'/app.nld.gob.mx/assets/'.substr($post['imagen'], 30));
         if(isset($post['imagen']) && $post['imagen'] != '' && file_exists($_SERVER['DOCUMENT_ROOT'].'/assets/'.substr($post['imagen'], 30))){
             unlink($_SERVER['DOCUMENT_ROOT'].'/assets/'.substr($post['imagen'], 30));
         }
         
         if($post['id'] == 0 || $post['id'] == ''){
             $post['id'] = $this->db->query('SELECT id FROM infopagina ORDER BY id DESC LIMIT 1')->row('id');
         }
         
         $ruta = $_SERVER['DOCUMENT_ROOT'].'/assets/';
             if(array_key_exists('documento', $_FILES)){
                 if (!is_dir($ruta)) {
                     mkdir($ruta, 0777, true);
                 }
                 $mi_archivo = 'documento';
                 $config['upload_path'] = $_SERVER['DOCUMENT_ROOT'].'/assets/';
                 $config['allowed_types'] = 'png|jpeg|gif|jpg';
                 $config['encrypt_name'] = true;
                 $config['max_size'] = '51200';
     
                 $this->upload->initialize($config);
     
                 if (!$this->upload->do_upload($mi_archivo)) {
                     //*** ocurrio un error
                     $data['uploadError'] = $this->upload->display_errors();
                     echo $this->upload->display_errors();
                     return;
                 }else{
 
                 // Creando el array con los datos básicos del usuario
                 $infopagina = array(
                     'imagen'    => 'https://app.nld.gob.mx/assets/'.$this->upload->data('file_name'),
                 );
                 
                      // Actualizando la tabla de usuarios
                     $this->db->set($infopagina);
                     $this->db->where('id', $post['id']);
                     $this->db->update('infopagina');
                 }
                 
                 $data['uploadSuccess'] = $this->upload->data();
         }
 
         // Si la transacción presenta errores
         if($this->db->trans_status() === false)
         {
             $respuesta = array(
                 'respuesta' => 'Ocurrio un error al actualizar los datos',
                 'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
             );
             return $respuesta;
         }
 
         // De lo contrario
         else
         {
             $this->db->trans_commit();
             $respuesta = array(
                 'respuesta' => 'La información de la página ha sido actualizada correctamente',
                 'status' => REST_Controller::HTTP_OK
             );
             return $respuesta;
         }
    }

}